﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using Microsoft.Win32;

namespace Winfoot_7_SDK
{
    public enum RegOperation
    {
        KeyWrite,
        KeyDel,
        ValueWrite,
        ValueDel
    }

    [Serializable]
    public class WFRegistry
    {
        public WFRegistry()
        {

        }

        public WFRegistry(string path, string name, object value, RegistryValueKind registryValueKind, RegOperation regOperation)
            : this()
        {
            Path = path;
            Name = name;
            Value = value;
            RegistryValueKind = registryValueKind;
            RegOperation = regOperation;
        }

        public string Path
        {
            get;
            set;
        }

        public string Name
        {
            get;
            set;
        }

        public object Value
        {
            get;
            set;
        }

        public RegistryValueKind RegistryValueKind
        {
            get;
            set;
        }

        public RegOperation RegOperation
        {
            get;
            set;
        }
    }
}
